<?php

function saveReply($chat_id, $key, $value, $isGlobal = false){

    $file = $isGlobal 
        ? "data/global_replies.json" 
        : "data/groups/".$chat_id.".json";

    if(!file_exists($file)){
        file_put_contents($file, json_encode([]));
    }

    $data = json_decode(file_get_contents($file), true);

    if(!isset($data[$key])){
        $data[$key] = [];
    }

    $data[$key][] = $value;

    file_put_contents($file, json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
}

function isBanned($key){

    if(!file_exists("data/banned.txt")) return false;

    $banned = file("data/banned.txt", FILE_IGNORE_NEW_LINES);

    return in_array($key, $banned);
}

function getReply($chat_id, $text){

    $globalFile = "data/global_replies.json";
    $groupFile  = "data/groups/".$chat_id.".json";
    $defaultFile = "data/default.json";

    $replies = [];

    // اولویت 1: global
    if(file_exists($globalFile)){
        $global = json_decode(file_get_contents($globalFile), true);
        if(isset($global[$text])){
            return $global[$text][array_rand($global[$text])];
        }
    }

    // گروهی
    if(file_exists($groupFile)){
        $group = json_decode(file_get_contents($groupFile), true);
        if(isset($group[$text])){
            $replies = array_merge($replies, $group[$text]);
        }
    }

    // پیشفرض
    if(file_exists($defaultFile)){
        $default = json_decode(file_get_contents($defaultFile), true);
        if(isset($default[$text])){
            $replies = array_merge($replies, $default[$text]);
        }
    }

    if(!empty($replies)){
        return $replies[array_rand($replies)];
    }

    return false;
}